import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../util/processResponse";

const initialState = {
    data: null,
    isLoading: false,
    isSuccess: false,
    isError: false,
    error: null
};

export const deleteUser = createAsyncThunk(
    'user/delete-user',
    async ({url, access_token}) => {
        return await mutationResponse(url, 'DELETE', {}, access_token);
    }
);

const deleteUserSlice = createSlice({
    name: 'delete-user',
    initialState,
    reducers: {
        resetState: (state) => {
            state.data = null
            state.isLoading = false
            state.isSuccess = false
            state.isError = false
            state.error = null
        },
        setError: (state, {payload}) => {
            state.isError = true;
            state.error = payload
        }
    },
    extraReducers: (builder) => {
        builder.addCase(deleteUser.pending, (state) => {
            state.isLoading = true
        });
        builder.addCase(deleteUser.fulfilled, (state, {payload}) => {
            const {status} = payload || {};
            if(status?.code == 200) {
                state.isError = false;
                state.error = null;
                state.isSuccess = true;
                state.data = status?.message;
            } else if(status?.code == 422) {
                state.isError = true;
                state.error = status?.message;
                state.isSuccess = false;
            } else {
                state.isError = true;
                state.error = 'Internal Server Error';
                state.isSuccess = false;
            }
            state.isLoading = false
        });
        builder.addCase(deleteUser.rejected, (state) => {
            state.isLoading = false;
            state.isError = true;
            state.error = 'Internal Server Error';
            state.isSuccess = false;
        });
    }
});

export const {resetState, setError} = deleteUserSlice.actions;
export default deleteUserSlice.reducer;